from py_pli.pylib import GlobalVar

import asyncio
import json

from pylog.pylogger import PyLogger

from py_pli.pylib import send_msg

from urpc_enum.fancontrolparameter import FanControlParameter
from urpc_enum.systemcontrolparameter import SystemControlParameter

from fleming.common.firmware_util import *


#TODO Switch to Virtual Units. For now it was easier to use the firmware_test script instead.


# The delay in seconds for chaning the output in the tests.
#DELAY = 5
PWMDELAY = 0.1

async def fmb_test_script():

    #Test script for FMB
    #This script checks the following interfaces:
    
        #TMP 0 to 8 & FMB TMP Sensor & FCN TMP Sensor
        #CTRL
        #Frontpanel
        #6x 2P FANs
        #24V Power
        #4x TECs
        #8x PWM FANs
     
        #USB interface is tested prior during programming of FMB.

    
    fmb = get_node_endpoint('fmb')

    # Reset the ground control stop button status at the beginning of the test.
    GlobalVar.set_stop_gc(False)
    # Send information and test results to ground control, that will be printed in the output text box.
    
    fmbtest_error = 0
    pwmtest_error =    0
    
    await send_msg(json.dumps({'result': f"Start FMB Test"}))

    
    try:
        
        await asyncio.sleep(1)
        await start_firmware('fmb')

        # #TMP Test
        temp0 = (await fmb.GetAnalogInput(0))[0] * 256
        print(f"Temperature Sensor 0: {temp0:.2f} °C")
        temp1 = (await fmb.GetAnalogInput(1))[0] * 256
        print(f"Temperature Sensor 1: {temp1:.2f} °C")
        temp2 = (await fmb.GetAnalogInput(2))[0] * 256
        print(f"Temperature Sensor 2: {temp2:.2f} °C")
        temp3 = (await fmb.GetAnalogInput(3))[0] * 256
        print(f"Temperature Sensor 3: {temp3:.2f} °C")
        temp4 = (await fmb.GetAnalogInput(4))[0] * 256
        print(f"Temperature Sensor 4: {temp4:.2f} °C")
        temp5 = (await fmb.GetAnalogInput(5))[0] * 256
        print(f"Temperature Sensor 5: {temp5:.2f} °C")
        temp6 = (await fmb.GetAnalogInput(6))[0] * 256
        print(f"Temperature Sensor 6: {temp6:.2f} °C")
        temp7 = (await fmb.GetAnalogInput(7))[0] * 256
        print(f"Temperature Sensor 7: {temp7:.2f} °C")   
        temp8 = (await fmb.GetAnalogInput(8))[0] * 256
        print(f"FMB Temperature Sensor: {temp8:.2f} °C")      
        temp18 = (await fmb.GetAnalogInput(18))[0] * 256         
        print(f"FCN Temperature Sensor: {temp18:.2f} °C")              
        
        if (temp0 < 5 or temp0 > 50) or (temp1 < 5 or temp1 > 50) or (temp2 < 5 or temp2 > 50) or (temp3 < 5 or temp3 > 50) or (temp4 < 5 or temp4 > 50) or (temp5 < 5 or temp5 > 50) or (temp6 < 5 or temp6 > 50) or (temp7 < 5 or temp7 > 50) or (temp8 < 5 or temp8 > 50) or (temp18 < 5 or temp18 > 70):
            fmbtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED TMP Test"}))  
            await send_msg(json.dumps({'result': f"Temperature Sensor 0: {temp0:.2f} °C"}))
            await send_msg(json.dumps({'result': f"Temperature Sensor 1: {temp1:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 2: {temp2:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 3: {temp3:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 4: {temp4:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 5: {temp5:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 6: {temp6:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor 7: {temp7:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor FMB: {temp8:.2f} °C"}))     
            await send_msg(json.dumps({'result': f"Temperature Sensor FCN: {temp18:.2f} °C"}))     
        else:
            await send_msg(json.dumps({'result': f"PASSED TMP Test"}))    
            
            
        # CTRL Test
        await fmb.SetDigitalOutput(0, 1, timeout=1)
        await asyncio.sleep(0.1)
        powersw_on = (await fmb.GetDigitalInput(0))[0]
        print(f"powersw_on: {powersw_on}")              
        await fmb.SetDigitalOutput(0, 0, timeout=1)
        await asyncio.sleep(0.1)
        powersw_off = (await fmb.GetDigitalInput(0))[0]
        print(f"powersw_off: {powersw_off}")              

        if powersw_on == 0 or powersw_off == 1:
            fmbtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED CTRL Test"}))
            await send_msg(json.dumps({'result': f"PowerSW on: {powersw_on}"}))
            await send_msg(json.dumps({'result': f"PowerSW off: {powersw_off}"}))

        else:
            await send_msg(json.dumps({'result': f"PASSED CTRL Test"}))  

        # FP Test
        
        await fmb.Reset()
        await asyncio.sleep(0.5)    
        
        sys = get_system_control_endpoint()
        await sys.SetButtonLight(0, 0) 
        await sys.SetButtonLight(1, 0) 
        await sys.SetButtonLight(2, 0)
        
        await asyncio.sleep(1)
        
        await fmb.SetAnalogOutput(FMBAnalogOutput.BCR, 1, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.BCG, 1, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.BCB, 1, timeout=1)
        
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR0, 1, timeout=1) #orange left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR1, 1, timeout=1) #orange middle
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR2, 1, timeout=1) #orange right
               
        #await asyncio.sleep(0.3)               
        fp2_on = (await fmb.GetDigitalInput(6))[0]
        print(f"fp2_on: {fp2_on}")              

        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR0, 0, timeout=1) #orange left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR1, 0, timeout=1) #orange middle
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR2, 0, timeout=1) #orange right
            
        #await asyncio.sleep(0.3)            
        fp2_off = (await fmb.GetDigitalInput(6))[0]
        print(f"fp2_off: {fp2_off}")               


        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG0, 1, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG1, 1, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG2, 1, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG3, 1, timeout=1)
        
        #await asyncio.sleep(0.3)
        fp1_on = (await fmb.GetDigitalInput(5))[0]
        print(f"fp1_on: {fp1_on}")              

        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG0, 0, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG1, 0, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG2, 0, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSG3, 0, timeout=1)
        
        #await asyncio.sleep(0.3)
        fp1_off = (await fmb.GetDigitalInput(5))[0]
        print(f"fp1_off: {fp1_off}")              

        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB0, 1, timeout=1) #green left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB1, 1, timeout=1) #green middle left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB2, 1, timeout=1) #green middle
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB3, 1, timeout=1) #green middle right
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR3, 1, timeout=1) #green right
               
        #await asyncio.sleep(0.3)
        fp3_on = (await fmb.GetDigitalInput(7))[0]
        print(f"fp3_on: {fp3_on}")
        
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB0, 0, timeout=1) #green left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB1, 0, timeout=1) #green middle left
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB2, 0, timeout=1) #green middle
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSB3, 0, timeout=1) #green middle right
        await fmb.SetAnalogOutput(FMBAnalogOutput.GSR3, 0, timeout=1) #green right
                         
        #await asyncio.sleep(0.3)
        fp3_off = (await fmb.GetDigitalInput(7))[0]
        print(f"fp3_off: {fp3_off}")

        await fmb.SetAnalogOutput(FMBAnalogOutput.BCR, 0, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.BCG, 0, timeout=1)
        await fmb.SetAnalogOutput(FMBAnalogOutput.BCB, 0, timeout=1)
        
        
        
        if fp1_on == 0 or fp2_on == 0 or fp3_on == 0 or fp1_off == 1 or fp2_off == 1 or fp3_off == 1:
            fmbtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED FP Test"}))
            await send_msg(json.dumps({'result': f"FP1 on: {fp1_on}"}))
            await send_msg(json.dumps({'result': f"FP1 off: {fp1_off}"}))
            await send_msg(json.dumps({'result': f"FP2 on: {fp2_on}"}))
            await send_msg(json.dumps({'result': f"FP2 off: {fp2_off}"}))
            await send_msg(json.dumps({'result': f"FP3 on: {fp3_on}"}))
            await send_msg(json.dumps({'result': f"FP3 off: {fp3_off}"}))
        else:
            await send_msg(json.dumps({'result': f"PASSED FP Test"}))
            
        
        # 2P FAN + 24V PWR test
                
        await fmb.SetDigitalOutput(7, 1, timeout=1) #deactivate load relay
        
        fan_off = (await fmb.GetDigitalInput(5))[0]
        pwr_off = (await fmb.GetDigitalInput(6))[0]
        print(f"fan_off: {fan_off}")
        print(f"pwr_off: {pwr_off}")

        await fmb.SetDigitalOutput(7, 0, timeout=1) #activate load relay
        await asyncio.sleep(1)
        
        fan_on = (await fmb.GetDigitalInput(5))[0]
        pwr_on = (await fmb.GetDigitalInput(6))[0]
        
        await fmb.SetDigitalOutput(7, 1, timeout=1) #deactivate load relay
        print(f"fan_on: {fan_on}")
        print(f"pwr_on: {pwr_on}")

        if fan_on == 0 or pwr_on == 0 or fan_off == 1 or pwr_off == 1:
            fmbtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED 2P FAN + PWR Test"}))
            await send_msg(json.dumps({'result': f"FAN on: {fan_on}"}))
            await send_msg(json.dumps({'result': f"FAN off: {fan_off}"}))
            await send_msg(json.dumps({'result': f"PWR on: {pwr_on}"}))
            await send_msg(json.dumps({'result': f"PWR off: {pwr_off}"}))
        else:
            await send_msg(json.dumps({'result': f"PASSED 2P FAN + PWR Test"}))
            
        #TEST TECs
        
        await asyncio.sleep(2)

        await fmb.SetDigitalOutput(7, 0, timeout=1) #activate load relay
        await asyncio.sleep(0.5)

        htu_off = (await fmb.GetAnalogInput(21))[0]*4.096*2*11
        htl_off = (await fmb.GetAnalogInput(22))[0]*4.096*2*11
        htb_off = (await fmb.GetAnalogInput(23))[0]*4.096*2*11
        tec_off = (await fmb.GetAnalogInput(24))[0]*4.096*2*11
        print(f"htu_off: {htu_off}")
        print(f"htl_off: {htl_off}")
        print(f"htb_off: {htb_off}")
        print(f"tec_off: {tec_off}")


        await fmb.SetAnalogOutput(0, 0.99, timeout=1)
        await asyncio.sleep(0.7)
        htu_on = (await fmb.GetAnalogInput(21))[0]*4.096*2*11
        print(f"htu_on: {htu_on}")
        await fmb.SetAnalogOutput(0, 0, timeout=1)

        await fmb.SetAnalogOutput(1, 0.99, timeout=1)   
        await asyncio.sleep(0.7)
        htl_on = (await fmb.GetAnalogInput(22))[0]*4.096*2*11
        print(f"htl_on: {htl_on}")
        await fmb.SetAnalogOutput(1, 0, timeout=1)   
       
        await fmb.SetAnalogOutput(2, 0.99, timeout=1)    
        await asyncio.sleep(0.7)
        htb_on = (await fmb.GetAnalogInput(23))[0]*4.096*2*11
        print(f"htb_on: {htb_on}")
        await fmb.SetAnalogOutput(2, 0, timeout=1)   

        await fmb.SetAnalogOutput(3, 0.99, timeout=1)    
        await asyncio.sleep(0.7)
        tec_on = (await fmb.GetAnalogInput(24))[0]*4.096*2*11
        print(f"tec_on: {tec_on}")
        await fmb.SetAnalogOutput(3, 0.0, timeout=1)    
        
        #activate htu so that the relay is turned on for av1 and av2 analoge inputs
        
        await fmb.SetAnalogOutput(0, 0.99, timeout=1)
        await asyncio.sleep(0.7)
        
        await fmb.SetAnalogOutput(15, 0.2, timeout=1)
        await asyncio.sleep(0.2)
        await fmb.SetAnalogOutput(15, 0.30, timeout=1)
        await asyncio.sleep(0.3)
        av1_on = (await fmb.GetAnalogInput(22))[0]*4.096*2*11
        print(f"av1_on: {av1_on}")
        await fmb.SetAnalogOutput(15, 0, timeout=1)
        
        await asyncio.sleep(0.3)
        
        await fmb.SetAnalogOutput(16, 0.2, timeout=1)
        await asyncio.sleep(0.2)
        await fmb.SetAnalogOutput(16, 0.30, timeout=1)
        await asyncio.sleep(0.3)
        av2_on = (await fmb.GetAnalogInput(23))[0]*4.096*2*11
        print(f"av2_on: {av2_on}")
        await fmb.SetAnalogOutput(16, 0, timeout=1)

        await fmb.SetAnalogOutput(0, 0.0, timeout=1)
        await fmb.SetDigitalOutput(7, 1, timeout=1) #deactivate load relay
        
        
        if htu_off > 0 or htl_off > 0 or htb_off > 0 or tec_off > 0 or htu_on < 20 or htu_on > 24 or htl_on < 20 or htl_on > 24 or htb_on < 20 or htb_on > 24 or tec_on < 20 or tec_on > 24 or av1_on < 6 or av1_on > 10 or av2_on < 6 or av2_on > 10:
            fmbtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED TEC Test"}))
            await send_msg(json.dumps({'result': f"HTU on: {htu_on}"}))
            await send_msg(json.dumps({'result': f"HTU off: {htu_off}"}))
            await send_msg(json.dumps({'result': f"HTL on: {htl_on}"}))
            await send_msg(json.dumps({'result': f"HTL off: {htl_off}"}))  
            await send_msg(json.dumps({'result': f"HTB on: {htb_on}"}))
            await send_msg(json.dumps({'result': f"HTB off: {htb_off}"}))  
            await send_msg(json.dumps({'result': f"TEC on: {tec_on}"}))
            await send_msg(json.dumps({'result': f"AV1 on: {av1_on}"}))
            await send_msg(json.dumps({'result': f"AV2 on: {av2_on}"}))
            
        else:
            await send_msg(json.dumps({'result': f"PASSED TEC Test"}))
            
        await fmb.Reset()
        await asyncio.sleep(1)        
        await start_firmware('fmb')

        #TEST PWM FANs
        
        await fmb.SetDigitalOutput(5, 0, timeout=1)
        await fmb.SetDigitalOutput(6, 0, timeout=1)
        await fmb.SetAnalogOutput(15, 0, timeout=1)
        await fmb.SetAnalogOutput(16, 0, timeout=1)


            
        meas = get_measurement_endpoint()
        fan = get_fan_control_endpoint('fmb_fan')
            
        await fan.SetParameter(0, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(1, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(2, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(3, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(4, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(5, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(6, FanControlParameter.SpeedSampleTime, 1, timeout=1)
        await fan.SetParameter(8, FanControlParameter.SpeedSampleTime, 1, timeout=1)


        await asyncio.sleep(1)     


        await fmb.SetAnalogOutput(8, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_100_on = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_100_on: {pwm1_freq_100_on}")
        
        await fmb.SetAnalogOutput(8, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_50_on = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_50_on: {pwm1_freq_50_on}")
        
        await fmb.SetAnalogOutput(8, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_0_on = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_0_on: {pwm1_freq_0_on}")

        await fmb.SetAnalogOutput(9, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_100_on = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_100_on: {pwm2_freq_100_on}")
        
        await fmb.SetAnalogOutput(9, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_50_on = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_50_on: {pwm2_freq_50_on}")
        
        await fmb.SetAnalogOutput(9, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_0_on = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_0_on: {pwm2_freq_0_on}")    
        
        await fmb.SetAnalogOutput(10, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_100_on = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_100_on: {pwm3_freq_100_on}")
        
        await fmb.SetAnalogOutput(10, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_50_on = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_50_on: {pwm3_freq_50_on}")
        
        await fmb.SetAnalogOutput(10, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_0_on = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_0_on: {pwm3_freq_0_on}")
        
        await fmb.SetAnalogOutput(11, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_100_on = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_100_on: {pwm4_freq_100_on}")
        
        await fmb.SetAnalogOutput(11, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_50_on = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_50_on: {pwm4_freq_50_on}")
        
        await fmb.SetAnalogOutput(11, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_0_on = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_0_on: {pwm4_freq_0_on}")

        await fmb.SetAnalogOutput(12, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_100_on = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_100_on: {pwm5_freq_100_on}")
        
        await fmb.SetAnalogOutput(12, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_50_on = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_50_on: {pwm5_freq_50_on}")
        
        await fmb.SetAnalogOutput(12, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_0_on = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_0_on: {pwm5_freq_0_on}")

        await fmb.SetAnalogOutput(13, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_100_on = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_100_on: {pwm6_freq_100_on}")
        
        await fmb.SetAnalogOutput(13, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_50_on = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_50_on: {pwm6_freq_50_on}")
        
        await fmb.SetAnalogOutput(13, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_0_on = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_0_on: {pwm6_freq_0_on}")    
        
        await fmb.SetAnalogOutput(14, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_100_on = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_100_on: {pwm7_freq_100_on}")
        
        await fmb.SetAnalogOutput(14, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_50_on = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_50_on: {pwm7_freq_50_on}")
        
        await fmb.SetAnalogOutput(14, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_0_on = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_0_on: {pwm7_freq_0_on}")
        
        await fmb.SetAnalogOutput(17, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_100_on = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_100_on: {pwm8_freq_100_on}")
        
        await fmb.SetAnalogOutput(17, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_50_on = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_50_on: {pwm8_freq_50_on}")
        
        await fmb.SetAnalogOutput(17, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_0_on = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_0_on: {pwm8_freq_0_on}")

        await fmb.SetAnalogOutput(15, 0.96, timeout=1)
        await asyncio.sleep(1)        

        await fmb.SetAnalogOutput(8, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_100_off = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_100_off: {pwm1_freq_100_off}")
        
        await fmb.SetAnalogOutput(8, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_50_off = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_50_off: {pwm1_freq_50_off}")
        
        await fmb.SetAnalogOutput(8, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm1_freq_0_off = (await fan.GetSpeed(0))[0] / 60
        print(f"pwm1_freq_0_off: {pwm1_freq_0_off}")

        await fmb.SetAnalogOutput(9, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_100_off = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_100_off: {pwm2_freq_100_off}")
        
        await fmb.SetAnalogOutput(9, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_50_off = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_50_off: {pwm2_freq_50_off}")
        
        await fmb.SetAnalogOutput(9, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm2_freq_0_off = (await fan.GetSpeed(1))[0] / 60
        print(f"pwm2_freq_0_off: {pwm2_freq_0_off}")    
        
        await fmb.SetAnalogOutput(10, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_100_off = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_100_off: {pwm3_freq_100_off}")
        
        await fmb.SetAnalogOutput(10, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_50_off = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_50_off: {pwm3_freq_50_off}")
        
        await fmb.SetAnalogOutput(10, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm3_freq_0_off = (await fan.GetSpeed(2))[0] / 60
        print(f"pwm3_freq_0_off: {pwm3_freq_0_off}")
        
        await fmb.SetAnalogOutput(11, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_100_off = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_100_off: {pwm4_freq_100_off}")
        
        await fmb.SetAnalogOutput(11, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_50_off = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_50_off: {pwm4_freq_50_off}")
        
        await fmb.SetAnalogOutput(11, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm4_freq_0_off = (await fan.GetSpeed(3))[0] / 60
        print(f"pwm4_freq_0_off: {pwm4_freq_0_off}")

        await fmb.SetAnalogOutput(15, 0, timeout=1)
        await asyncio.sleep(1)        
        await fmb.SetAnalogOutput(16, 0.96, timeout=1)
        await asyncio.sleep(1)        

        await fmb.SetAnalogOutput(12, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_100_off = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_100_off: {pwm5_freq_100_off}")
        
        await fmb.SetAnalogOutput(12, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_50_off = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_50_off: {pwm5_freq_50_off}")
        
        await fmb.SetAnalogOutput(12, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm5_freq_0_off = (await fan.GetSpeed(4))[0] / 60
        print(f"pwm5_freq_0_off: {pwm5_freq_0_off}")

        await fmb.SetAnalogOutput(13, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_100_off = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_100_off: {pwm6_freq_100_off}")
        
        await fmb.SetAnalogOutput(13, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_50_off = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_50_off: {pwm6_freq_50_off}")
        
        await fmb.SetAnalogOutput(13, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm6_freq_0_off = (await fan.GetSpeed(5))[0] / 60
        print(f"pwm6_freq_0_off: {pwm6_freq_0_off}")    
        
        await fmb.SetAnalogOutput(14, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_100_off = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_100_off: {pwm7_freq_100_off}")
        
        await fmb.SetAnalogOutput(14, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_50_off = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_50_off: {pwm7_freq_50_off}")
        
        await fmb.SetAnalogOutput(14, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm7_freq_0_off = (await fan.GetSpeed(6))[0] / 60
        print(f"pwm7_freq_0_off: {pwm7_freq_0_off}")
        
        await fmb.SetAnalogOutput(17, 1, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_100_off = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_100_off: {pwm8_freq_100_off}")
        
        await fmb.SetAnalogOutput(17, 0.5, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_50_off = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_50_off: {pwm8_freq_50_off}")
        
        await fmb.SetAnalogOutput(17, 0, timeout=1)
        await asyncio.sleep(PWMDELAY)        
        pwm8_freq_0_off = (await fan.GetSpeed(8))[0] / 60
        print(f"pwm8_freq_0_off: {pwm8_freq_0_off}")

        await fmb.SetAnalogOutput(16, 0, timeout=1)


        if pwm1_freq_0_on != 0 or (pwm1_freq_50_on < (25000 * 0.99)) or (pwm1_freq_50_on > (25000 * 1.01)) or pwm1_freq_100_on != 0 or pwm1_freq_0_off != 0 or pwm1_freq_50_off != 0 or pwm1_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN1 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm1_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm1_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm1_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm1_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm1_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm1_freq_0_off}"}))
        if pwm2_freq_0_on != 0 or (pwm2_freq_50_on < (25000 * 0.99)) or (pwm2_freq_50_on > (25000 * 1.01)) or pwm2_freq_100_on != 0 or pwm2_freq_0_off != 0 or pwm2_freq_50_off != 0 or pwm2_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN2 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm2_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm2_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm2_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm2_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm2_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm2_freq_0_off}"}))
        if pwm3_freq_0_on != 0 or (pwm3_freq_50_on < (25000 * 0.99)) or (pwm3_freq_50_on > (25000 * 1.01)) or pwm3_freq_100_on != 0 or pwm3_freq_0_off != 0 or pwm3_freq_50_off != 0 or pwm3_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1            
            await send_msg(json.dumps({'result': f"FAILED PWM FAN3 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm3_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm3_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm3_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm3_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm3_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm3_freq_0_off}"}))
        if pwm4_freq_0_on != 0 or (pwm4_freq_50_on < (25000 * 0.99)) or (pwm4_freq_50_on > (25000 * 1.01)) or pwm4_freq_100_on != 0 or pwm4_freq_0_off != 0 or pwm4_freq_50_off != 0 or pwm4_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN4 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm4_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm4_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm4_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm4_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm4_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm4_freq_0_off}"}))
        if pwm5_freq_0_on != 0 or (pwm5_freq_50_on < (25000 * 0.99)) or (pwm5_freq_50_on > (25000 * 1.01)) or pwm5_freq_100_on != 0 or pwm5_freq_0_off != 0 or pwm5_freq_50_off != 0 or pwm5_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN5 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm5_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm5_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm5_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm5_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm5_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm5_freq_0_off}"}))
        if pwm6_freq_0_on != 0 or (pwm6_freq_50_on < (25000 * 0.99)) or (pwm6_freq_50_on > (25000 * 1.01)) or pwm6_freq_100_on != 0 or pwm6_freq_0_off != 0 or pwm6_freq_50_off != 0 or pwm6_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN6 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm6_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm6_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm6_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm6_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm6_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm6_freq_0_off}"}))
        if pwm7_freq_0_on != 0 or (pwm7_freq_50_on < (25000 * 0.99)) or (pwm7_freq_50_on > (25000 * 1.01)) or pwm7_freq_100_on != 0 or pwm7_freq_0_off != 0 or pwm7_freq_50_off != 0 or pwm7_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN7 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm7_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm7_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm7_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm7_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm7_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm7_freq_0_off}"}))
        if pwm8_freq_0_on != 0 or (pwm8_freq_50_on < (25000 * 0.99)) or (pwm8_freq_50_on > (25000 * 1.01)) or pwm8_freq_100_on != 0 or pwm8_freq_0_off != 0 or pwm8_freq_50_off != 0 or pwm8_freq_100_off != 0:
            fmbtest_error = 1
            pwmtest_error = 1
            await send_msg(json.dumps({'result': f"FAILED PWM FAN8 Test"}))
            await send_msg(json.dumps({'result': f"100% on: {pwm8_freq_100_on}"}))
            await send_msg(json.dumps({'result': f"50% on: {pwm8_freq_50_on}"}))
            await send_msg(json.dumps({'result': f"0% on: {pwm8_freq_0_on}"}))
            await send_msg(json.dumps({'result': f"100% off: {pwm8_freq_100_off}"}))
            await send_msg(json.dumps({'result': f"50% off: {pwm8_freq_50_off}"}))
            await send_msg(json.dumps({'result': f"0% off: {pwm8_freq_0_off}"}))
        
        if pwmtest_error == 1:
            await send_msg(json.dumps({'result': f"FAILED PWM FAN Test"}))
        else:
            await send_msg(json.dumps({'result': f"PASSED PWM FAN Test"}))
            
            
        if fmbtest_error == 0:
            await send_msg(json.dumps({'result': f"FMB test successful. Continue with next DUT."}))
        else:
            await send_msg(json.dumps({'result': f"FMB test failed. Check error messages."}))

            
    finally:
    
        # By using a try/finally the power is always switched off when leaving the test function.
        await asyncio.sleep(1)
        await fmb.Reset()
        await asyncio.sleep(0.1)     